#  Gm_Aftermath_V2 (aka Gm_Aftermath Night and Day)

This repo contains the (hopefully) complete source for Gm Aftermath Night and 
Day.

## Licensing / Rules

1.  You may use these source files to create your own modifications of 
    Aftermath Night and Day.
2.  You must credit the original author (Nanospork) when sharing your 
    version of the map. See the end of the ReadMe for tips.
3.  You must __NOT__ give your map a name that implies it could be an
    official sequel to the Gm_Aftermath line.
    a.  In other words, it's okay to call your map: `Gm_Aftermath_Jerry_Edit`
        or `Gm_Aftermath_Zombies` or `Gm_Aftermath_MyRolePlayServer`
    b.  It's also okay to call it something totally new, as long as you
        still credit the original author.
    c.  It is __NOT__ okay to give your map a name like `Gm_Aftermath_V3`

## Building the Map

Note that the Aftermath series of maps was built entirely within the "HL2" 
version of Hammer, not the Gmod version. As such, some of these instructions 
may differ if building in Gmod's Hammer.

### Installing Content

To build the map, you'll need to install the content files in the usual 
location for content creation. The following folders and files will need to be 
copied and merged to your `steamapps\common\Half-Life 2\hl2\` folders
(or the appropriate source for the version of Hammer you're using):

```
materials\
models\
particles\
aftermath_detail.vbsp
```

You'll also need to rename `gm_aftermath_night_particles.txt` as appropriate 
for your new map name and copy it into the final installation's `maps` folder 
to fix the waterfall particles.

### Preparing the Map File

There are two VMFs included, one for Night and one for Day. Please note that 
Aftermath_Night is the "main" version of the map. All of the map-specific 
textures etc. refer to file paths with the name `gm_aftermath_night`.

In either map file, you _should_ be able to toggle the night-specific VisGroups 
(the skybox and lights, mainly.) If you are making a derivative map with 
both nighttime and daytime versions, make sure to add Night-specific details to 
a VisGroup so you can turn them on and off in the same way!

### Compiling the Map

Compile the map in the usual way, as preferred.

### Building Cubemaps

You should build cubemaps before packing content. This can be done in-game, but 
you must build both LDR and HDR. You can also use a tool like CompilePal. Do 
__NOT__ use CompilePal for packing; it won't get the paths right!

https://github.com/ruarai/CompilePal/releases/tag/v027

### Packing Content

In order for the map to function properly, all custom content MUST be packed 
into it _with the appropriate relative path_. This means you'll need to fix up
the path structure to resemble the structure of this repository. Content that 
must be packed includes all of the content in the following folders:

```
materials\
models\
particles\
maps\gm_aftermath_night_particles.txt
scripts\
```

Maintain the relative paths as-listed. You can use VIDE to pack the content:

http://www.riintouge.com/VIDE/

## Sharing

When packaging the map into an addon file, be sure to include the 
`aftermath_prop_physics.lua` script, which enables conversion of all aftermath 
props between "static" (actually dynamic) and physics with the 
`Afermath_ConvertProps` concommand.

This script should be included with the relative path in this repo 
(`lua\autorun\server\`). The script should __NOT__ be packed directly into the 
map file.

### Crediting

Please credit the original author by including a line in the description
of any videos, workshop uploads, or other distributions. You can say 
something like: 

"Gm_Aftermath Night and Day originally created by Nanospork".

I would also really appreciate if you include a link to the original 
workshop upload: 

https://steamcommunity.com/sharedfiles/filedetails/?id=428781078
